/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.sf.jasperreports.components.barcode4j.QRCodeBean;
import net.sf.jasperreports.components.barcode4j.QRCodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class QRCodeRasterizedImageProducer
implements QRCodeImageProducer {
    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, QRCodeBean qrCodeBean, String message) {
        QRCodeWriter writer = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)qrCodeBean.getErrorCorrectionLevel().getErrorCorrectionLevel());
        int resolution = JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty(componentElement, "net.sf.jasperreports.components.barcode4j.image.resolution", 300);
        int margin = qrCodeBean.getMargin() == null ? 0 : qrCodeBean.getMargin();
        try {
            BitMatrix matrix = writer.encode(message, BarcodeFormat.QR_CODE, (int)((float)resolution / 72.0f * (float)(componentElement.getWidth() - margin)), (int)((float)resolution / 72.0f * (float)(componentElement.getHeight() - margin)), hints);
            BufferedImage image = this.getImage(matrix, componentElement.getForecolor(), componentElement.getBackcolor());
            return RenderableUtil.getInstance(jasperReportsContext).getRenderable(image, ImageTypeEnum.PNG, OnErrorTypeEnum.ERROR);
        }
        catch (WriterException e) {
            throw new JRRuntimeException(e);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public BufferedImage getImage(BitMatrix matrix, Color onColor, Color offColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int type = Color.BLACK.equals(onColor) && Color.WHITE.equals(offColor) || Color.WHITE.equals(onColor) && Color.BLACK.equals(offColor) ? 12 : 1;
        BufferedImage image = new BufferedImage(width, height, type);
        int onArgb = JRColorUtil.getOpaqueArgb(onColor, Color.BLACK);
        int offArgb = JRColorUtil.getOpaqueArgb(offColor, Color.WHITE);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? onArgb : offArgb);
            }
        }
        return image;
    }
}

