/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Locale;
import java.util.MissingResourceException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;

public class JRException
extends Exception {
    private static final long serialVersionUID = 10200L;
    public static final String ERROR_MESSAGES_BUNDLE = "jasperreports_messages";
    public static final String ERROR_MESSAGE_KEY_PREFIX = "net.sf.jasperreports.exception.";
    private String messageKey;
    private Object[] args;
    private JasperReportsContext jasperReportsContext;
    private Locale locale;

    public JRException(String message) {
        super(message);
    }

    public JRException(Throwable t) {
        super(t);
    }

    public JRException(String message, Throwable t) {
        super(message, t);
    }

    public JRException(String messageKey, Object[] args, Throwable t) {
        super(messageKey, t);
        this.messageKey = messageKey;
        this.args = args;
    }

    public JRException(String messageKey, Object[] args) {
        super(messageKey);
        this.messageKey = messageKey;
        this.args = args;
    }

    public JRException(String messageKey, Object[] args, JasperReportsContext jasperReportsContext, Locale locale) {
        super(messageKey);
        this.messageKey = messageKey;
        this.args = args;
        this.jasperReportsContext = jasperReportsContext;
        this.locale = locale;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return this.getMessage(this.jasperReportsContext, this.locale);
    }

    public String getMessage(JasperReportsContext jasperReportsContext, Locale locale) {
        if (this.messageKey != null) {
            return this.resolveMessage(jasperReportsContext == null ? DefaultJasperReportsContext.getInstance() : jasperReportsContext, locale == null ? Locale.getDefault() : locale);
        }
        return super.getMessage();
    }

    protected String resolveMessage(JasperReportsContext jasperReportsContext, Locale locale) {
        if (this.messageKey != null) {
            try {
                String bundleName = this.getMessageBundleName();
                MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
                return messageProvider.getMessage(this.getMessageKeyPrefix() + this.messageKey, this.args, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.messageKey;
    }

    protected String getMessageBundleName() {
        return ERROR_MESSAGES_BUNDLE;
    }

    protected String getMessageKeyPrefix() {
        return ERROR_MESSAGE_KEY_PREFIX;
    }
}

