/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;

public abstract class AbstractXlsDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_XLS_COLUMN_NAMES_MISMATCH_COLUMN_INDEXES = "data.xls.column.names.mismatch.column.indexes";
    public static final String EXCEPTION_MESSAGE_KEY_XLS_FIELD_VALUE_NOT_RETRIEVED = "data.xls.field.value.not.retrieved";
    public static final String EXCEPTION_MESSAGE_KEY_XLS_SHEET_INDEX_OUT_OF_RANGE = "data.xls.sheet.index.out.of.range";
    public static final String EXCEPTION_MESSAGE_KEY_XLS_SHEET_NOT_FOUND = "data.xls.sheet.not.found";
    protected String sheetSelection;
    protected DateFormat dateFormat = new SimpleDateFormat();
    protected NumberFormat numberFormat = new DecimalFormat();
    protected Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    protected boolean useFirstRowAsHeader;

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkReadStarted();
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.checkReadStarted();
        this.numberFormat = numberFormat;
    }

    public void setColumnNames(String[] columnNames) {
        this.checkReadStarted();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], i);
        }
    }

    public void setColumnNames(String[] columnNames, int[] columnIndexes) {
        this.checkReadStarted();
        if (columnNames.length != columnIndexes.length) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XLS_COLUMN_NAMES_MISMATCH_COLUMN_INDEXES, (Object[])null);
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], columnIndexes[i]);
        }
    }

    public void setColumnIndexes(Integer[] columnIndexes) {
        this.checkReadStarted();
        for (int i = 0; i < columnIndexes.length; ++i) {
            this.columnNames.put("COLUMN_" + i, columnIndexes[i]);
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.checkReadStarted();
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public abstract void close();

    protected abstract void checkReadStarted();

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }

    public String getSheetSelection() {
        return this.sheetSelection;
    }

    public void setSheetSelection(String sheetSelection) {
        this.checkReadStarted();
        this.sheetSelection = sheetSelection;
    }
}

