/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterContext;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.TextExporterConfiguration;
import net.sf.jasperreports.export.TextReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;

public class JRTextExporter
extends JRAbstractExporter<TextReportConfiguration, TextExporterConfiguration, WriterExporterOutput, JRTextExporterContext> {
    private static final String TXT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.txt.";
    public static final String EXCEPTION_MESSAGE_KEY_REQUIRED_POSITIVE_PAGE_OR_CHARACTER_WIDTH = "export.text.required.positive.page.or.character.width";
    public static final String EXCEPTION_MESSAGE_KEY_CHARACTER_WIDTH_NEGATIVE = "export.text.character.width.negative";
    public static final String EXCEPTION_MESSAGE_KEY_REQUIRED_POSITIVE_PAGE_OR_CHARACTER_HEIGHT = "export.text.required.positive.page.or.character.height";
    public static final String EXCEPTION_MESSAGE_KEY_CHARACTER_HEIGHT_NEGATIVE = "export.text.character.height.negative";
    protected Writer writer;
    char[][] pageData;
    protected int pageWidthInChars;
    protected int pageHeightInChars;
    protected float charWidth;
    protected float charHeight;
    protected String pageSeparator;
    protected String lineSeparator;
    protected boolean isTrimLineRight;
    protected static final String systemLineSeparator = System.getProperty("line.separator");

    public JRTextExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRTextExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<TextExporterConfiguration> getConfigurationInterface() {
        return TextExporterConfiguration.class;
    }

    @Override
    protected Class<TextReportConfiguration> getItemConfigurationInterface() {
        return TextReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        TextExporterConfiguration configuration = (TextExporterConfiguration)this.getCurrentConfiguration();
        this.lineSeparator = configuration.getLineSeparator();
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        this.pageSeparator = configuration.getPageSeparator();
        if (this.pageSeparator == null) {
            this.pageSeparator = systemLineSeparator + systemLineSeparator;
        }
        this.isTrimLineRight = configuration.isTrimLineRight();
    }

    @Override
    protected void initReport() {
        super.initReport();
        TextReportConfiguration configuration = (TextReportConfiguration)this.getCurrentItemConfiguration();
        Float charWidthValue = configuration.getCharWidth();
        float f = this.charWidth = charWidthValue == null ? 0.0f : charWidthValue.floatValue();
        if (this.charWidth < 0.0f) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHARACTER_WIDTH_NEGATIVE, (Object[])null);
        }
        if (this.charWidth == 0.0f) {
            Integer pageWidthInCharsValue = configuration.getPageWidthInChars();
            int n = this.pageWidthInChars = pageWidthInCharsValue == null ? 0 : pageWidthInCharsValue;
            if (this.pageWidthInChars <= 0) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REQUIRED_POSITIVE_PAGE_OR_CHARACTER_WIDTH, (Object[])null);
            }
            this.charWidth = (float)this.jasperPrint.getPageWidth() / (float)this.pageWidthInChars;
        } else {
            this.pageWidthInChars = (int)((float)this.jasperPrint.getPageWidth() / this.charWidth);
        }
        Float charHeightValue = configuration.getCharHeight();
        float f2 = this.charHeight = charHeightValue == null ? 0.0f : charHeightValue.floatValue();
        if (this.charHeight < 0.0f) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHARACTER_HEIGHT_NEGATIVE, (Object[])null);
        }
        if (this.charHeight == 0.0f) {
            Integer pageHeightInCharsValue = configuration.getPageHeightInChars();
            int n = this.pageHeightInChars = pageHeightInCharsValue == null ? 0 : pageHeightInCharsValue;
            if (this.pageHeightInChars <= 0) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REQUIRED_POSITIVE_PAGE_OR_CHARACTER_HEIGHT, (Object[])null);
            }
            this.charHeight = (float)this.jasperPrint.getPageHeight() / (float)this.pageHeightInChars;
        } else {
            this.pageHeightInChars = (int)((float)this.jasperPrint.getPageHeight() / this.charHeight);
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List<ExporterInputItem> items = this.exporterInput.getItems();
        for (int reportIndex = 0; reportIndex < items.size(); ++reportIndex) {
            ExporterInputItem item = items.get(reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            JRAbstractExporter.PageRange pageRange = this.getPageRange();
            int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
            int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
            for (int i = startPageIndex; i <= endPageIndex; ++i) {
                if (Thread.interrupted()) {
                    throw new ExportInterruptedException();
                }
                JRPrintPage page = pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        int i;
        List<JRPrintElement> elements = page.getElements();
        this.pageData = new char[this.pageHeightInChars][];
        for (i = 0; i < this.pageHeightInChars; ++i) {
            this.pageData[i] = new char[this.pageWidthInChars];
            Arrays.fill(this.pageData[i], ' ');
        }
        this.exportElements(elements);
        for (i = 0; i < this.pageHeightInChars; ++i) {
            int lineLength = this.pageWidthInChars;
            if (this.isTrimLineRight) {
                int j;
                for (j = this.pageWidthInChars - 1; j >= 0 && this.pageData[i][j] == ' '; --j) {
                }
                lineLength = j + 1;
            }
            this.writer.write(this.pageData[i], 0, lineLength);
            this.writer.write(this.lineSeparator);
        }
        this.writer.write(this.pageSeparator);
        JRExportProgressMonitor progressMonitor = ((TextReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportElements(List<JRPrintElement> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            JRPrintElement element = elements.get(i);
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.setFrameElementsOffset(frame, false);
            try {
                this.exportElements(frame.getElements());
                continue;
            }
            finally {
                this.restoreElementOffsets();
            }
        }
    }

    protected void exportText(JRPrintText element) {
        int i;
        JRStyledText styledText;
        int colSpan = this.getWidthInChars(element.getWidth());
        int rowSpan = this.getHeightInChars(element.getHeight());
        int col = this.getWidthInChars(element.getX() + this.getOffsetX());
        int row = this.getHeightInChars(element.getY() + this.getOffsetY());
        if (col + colSpan > this.pageWidthInChars) {
            colSpan = this.pageWidthInChars - col;
        }
        String allText = (styledText = this.getStyledText(element)) == null ? "" : styledText.getText();
        if (rowSpan <= 0 || colSpan <= 0) {
            return;
        }
        if (allText != null && allText.length() == 0) {
            return;
        }
        StringBuffer[] rows = new StringBuffer[rowSpan];
        rows[0] = new StringBuffer();
        int rowIndex = 0;
        int rowPosition = 0;
        boolean isFirstLine = true;
        StringTokenizer lfTokenizer = new StringTokenizer(allText, "\n", true);
        block9: while (lfTokenizer.hasMoreTokens()) {
            String line = lfTokenizer.nextToken();
            if (isFirstLine && line.equals("\n")) {
                rows[rowIndex].append("");
                if (++rowIndex == rowSpan || !lfTokenizer.hasMoreTokens()) break;
                rowPosition = 0;
                rows[rowIndex] = new StringBuffer();
                line = lfTokenizer.nextToken();
            }
            isFirstLine = false;
            int emptyLinesCount = 0;
            while (line.equals("\n") && lfTokenizer.hasMoreTokens()) {
                ++emptyLinesCount;
                line = lfTokenizer.nextToken();
            }
            if (emptyLinesCount > 1) {
                for (i = 0; i < emptyLinesCount - 1; ++i) {
                    rows[rowIndex].append("");
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                    if (lfTokenizer.hasMoreTokens() || !line.equals("\n")) continue;
                    rows[rowIndex].append("");
                    break block9;
                }
            }
            if (line.equals("\n")) continue;
            StringTokenizer spaceTokenizer = new StringTokenizer(line, " ", true);
            while (spaceTokenizer.hasMoreTokens()) {
                String word = spaceTokenizer.nextToken();
                while (word.length() > colSpan) {
                    rows[rowIndex].append(word.substring(0, colSpan - rowPosition));
                    word = word.substring(colSpan - rowPosition, word.length());
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowPosition + word.length() > colSpan) {
                    if (++rowIndex == rowSpan) break block9;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowIndex > 0 && rowPosition == 0 && word.equals(" ")) continue;
                rows[rowIndex].append(word);
                rowPosition += word.length();
            }
            if (++rowIndex == rowSpan) break;
            rowPosition = 0;
            rows[rowIndex] = new StringBuffer();
        }
        int colOffset = 0;
        int rowOffset = 0;
        switch (element.getVerticalTextAlign()) {
            case BOTTOM: {
                rowOffset = rowSpan - rowIndex;
                break;
            }
            case MIDDLE: {
                rowOffset = (rowSpan - rowIndex) / 2;
            }
        }
        for (i = 0; i < rowIndex; ++i) {
            int pos;
            String line = rows[i].toString();
            for (pos = line.length() - 1; pos >= 0 && line.charAt(pos) == ' '; --pos) {
            }
            line = line.substring(0, pos + 1);
            switch (element.getHorizontalTextAlign()) {
                case RIGHT: {
                    colOffset = colSpan - line.length();
                    break;
                }
                case CENTER: {
                    colOffset = (colSpan - line.length()) / 2;
                    break;
                }
                case JUSTIFIED: {
                    if (i >= rowIndex - 1) break;
                    line = this.justifyText(line, colSpan);
                }
            }
            char[] chars = line.toCharArray();
            System.arraycopy(chars, 0, this.pageData[row + rowOffset + i], col + colOffset, chars.length);
        }
    }

    private String justifyText(String s, int width) {
        StringBuffer justified = new StringBuffer();
        StringTokenizer t = new StringTokenizer(s, " ");
        int tokenCount = t.countTokens();
        if (tokenCount <= 1) {
            return s;
        }
        String[] words = new String[tokenCount];
        int i = 0;
        while (t.hasMoreTokens()) {
            words[i++] = t.nextToken();
        }
        int emptySpace = width - s.length() + (words.length - 1);
        int spaceCount = emptySpace / (words.length - 1);
        int remainingSpace = emptySpace % (words.length - 1);
        char[] spaces = new char[spaceCount];
        Arrays.fill(spaces, ' ');
        for (i = 0; i < words.length - 1; ++i) {
            justified.append(words[i]);
            justified.append(spaces);
            if (i >= remainingSpace) continue;
            justified.append(' ');
        }
        justified.append(words[words.length - 1]);
        return justified.toString();
    }

    protected int getHeightInChars(int height) {
        return Math.round((float)height / this.charHeight);
    }

    protected int getWidthInChars(int width) {
        return Math.round((float)width / this.charWidth);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.styledTextUtil.getStyledText(textElement, this.noneSelector);
    }

    @Override
    public String getExporterKey() {
        return null;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return TXT_EXPORTER_PROPERTIES_PREFIX;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRTextExporterContext {
        protected ExporterContext() {
            super(JRTextExporter.this);
        }
    }
}

