/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.util.WebResourceHandler;

public class ImageWebResourceHandler
implements WebResourceHandler {
    public static final String EXCEPTION_MESSAGE_KEY_JASPERPRINT_NOT_FOUND = "web.util.jasperprint.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_CONTEXT_NOT_FOUND = "web.util.report.context.not.found";
    public static final String REQUEST_PARAMETER_IMAGE_NAME = "image";

    @Override
    public boolean handleResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, HttpServletResponse response) {
        String imageName = request.getParameter(REQUEST_PARAMETER_IMAGE_NAME);
        if (imageName == null) {
            return false;
        }
        byte[] imageData = null;
        String imageMimeType = null;
        if ("px".equals(imageName)) {
            try {
                Renderable pxRenderer = RenderableUtil.getInstance(jasperReportsContext).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
                imageData = pxRenderer.getImageData(jasperReportsContext);
                imageMimeType = ImageTypeEnum.GIF.getMimeType();
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        WebReportContext webReportContext = WebReportContext.getInstance(request, false);
        if (webReportContext == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REPORT_CONTEXT_NOT_FOUND, (Object[])null);
        }
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        if (jasperPrintAccessor == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_JASPERPRINT_NOT_FOUND, (Object[])null);
        }
        List<JasperPrint> jasperPrintList = Collections.singletonList(jasperPrintAccessor.getJasperPrint());
        JRPrintImage image = HtmlExporter.getImage(jasperPrintList, imageName);
        Renderable renderer = image.getRenderable();
        if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
            renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
        }
        imageMimeType = renderer.getImageTypeValue().getMimeType();
        try {
            imageData = renderer.getImageData(jasperReportsContext);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream outputStream = null;
            try {
                outputStream = response.getOutputStream();
                outputStream.write(imageData, 0, imageData.length);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return true;
    }
}

